<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('membership.list_title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="<?php echo e(route('membership.index')); ?>">
										<?php echo e(csrf_field()); ?>

										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control"
												placeholder="<?php echo e(__('membership.search')); ?>" required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap"><?php echo e(__('membership.th_reg_no')); ?></th>
													<th><?php echo e(__('membership.th_name')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_membership_type')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_valid_from')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_valid_to')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_amount')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_paid')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_due')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_payment_status')); ?></th>
													<th class="nowrap"><?php echo e(__('membership.th_membership_status')); ?></th>
													<th class="fixed-width-td"><?php echo e(__('membership.th_action')); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php $__currentLoopData = $memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td class="align-middle">
														<?php echo e($membership->member->reg_no); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($membership->member->name); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($membership->membership_type->name); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(format_date($membership->valid_from)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(format_date($membership->valid_to)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(currency_symbol()); ?>

														<?php echo e(round_off($membership->membership_type->amount)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(currency_symbol()); ?>

														<?php echo e(paid_amount($membership->transactions)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(currency_symbol()); ?>

														<?php echo e(due_amount($membership->transactions)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo transaction_status($membership->transactions); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo membership_status($membership->valid_to); ?>

													</td>
													<td>
														<div class="d-flex justify-content-end">
															<?php if(due_amount($membership->transactions) > 0): ?>
															<a href="<?php echo e(route('transaction.create', $membership->id)); ?>"
																type="button" class="btn btn-success mr-2">
																<i class="fa fa-plus"></i>
															</a>
															<?php else: ?>
															<button type="button" class="btn btn-success mr-2" disabled>
																<i class="fa fa-plus"></i>
															</button>
															<?php endif; ?>

															<a href="<?php echo e(route('invoice.show', $membership->id)); ?>"
																type="button" class="btn btn-warning mr-2">
																<i class="fa fa-print"></i>
															</a>

															<form class="d-inline js-confirm-delete " method="POST"
																action="<?php echo e(route('membership.destroy', $membership->id)); ?>">
																<?php echo e(csrf_field()); ?>

																<?php echo method_field('DELETE'); ?>
																<button class="btn btn-primary">
																	<i class="fa fa-trash"></i>
																</button>
															</form>
														</div>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php if(count($memberships) == 0): ?>
												<tr>
													<td colspan="11">
														<p class="text-center mb-0"><?php echo e(__('membership.no_record_found')); ?></p>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										<?php if($paginate): ?>
										<?php echo e($memberships->links()); ?>

										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/membership/list.blade.php ENDPATH**/ ?>